<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Medicine extends Model 
{

    protected $table = 'medicines';
    public $timestamps = true;
    protected $fillable = array('name', 'price', 'type', 'company_id');

    public function company()
    {
        return $this->belongsTo('App\Models\Company');
    }

    public function rogets()
    {
        return $this->belongsToMany('App\Models\Roget');
    }

    public function quantities()
    {
        return $this->hasMany('App\Models\MedicineQuantity');
    }

    public function asks()
    {
        return $this->hasMany('App\Models\MedicineAsk');
    }

}